-- mods/zinc/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("zinc")

-- Lapis Lazuli Ore
minetest.register_node("zinc:stone_with_zinc", {
	description = S("zinc Ore"),
	tiles = {"default_stone.png^zinc_mineral_zinc.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'zinc:zinc 2'},  --The first and second drops ever
			},
			{
				items = {'zinc:zinc'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'zinc:zinc'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'zinc:zinc'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("zinc:zinc", {
	description = S("zinc"),
	inventory_image = "zinc.png",
})

-- Lapis Block
minetest.register_node("zinc:zincblock", {
	description = S("zinc Block"),
	tiles = {"zinc_zincblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Block Crafting
minetest.register_craft({
	output = 'zinc:zinc',
	recipe = {
		{'zinc:zinc', 'zinc:zinc', 'zinc:zinc'},
		{'zinc:zinc', 'zinc:zinc', 'zinc:zinc'},
		{'zinc:zinc', 'zinc:zinc', 'zinc:zinc'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'zinc:zinc 9',
	recipe = {
		{'zinc:zinc'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "zinc:stone_with_zinc",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "zinc:stone_with_zinc",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


